# Cleaning Service Website - PHP & Database Setup

## 📋 Project Overview

This is a professional cleaning service website that has been converted from static HTML to a dynamic PHP application with MySQL database integration. All pages now include header/footer components and database connectivity.

---

## ✅ Completed Conversions

### **Database & Configuration**
- ✓ `config.php` - Database connection configuration with error handling
- ✓ `setup_database.php` - Automatic database and table creation script

### **Header & Footer Components**
- ✓ `header.php` - Reusable header with navigation (all links updated to .php)
- ✓ `footer.php` - Reusable footer with social links and quick links

### **Main Pages (PHP)**
1. ✓ `index.php` - Home page with services and testimonials
2. ✓ `about.php` - About us page
3. ✓ `service.php` - Services listing page
4. ✓ `service-details.php` - Individual service details
5. ✓ `blog.php` - Blog listing page
6. ✓ `blog-details.php` - Individual blog post
7. ✓ `portfolio.php` - Gallery/portfolio page
8. ✓ `portfolio-details.php` - Portfolio item details
9. ✓ `team.php` - Team members page
10. ✓ `team-details.php` - Team member details
11. ✓ `contact.php` - Contact form page
12. ✓ `login.php` - User login page
13. ✓ `register.php` - User registration page
14. ✓ `404.php` - Error page

---

## 🗄️ Database Setup

### **Step 1: Run Database Setup**
1. Open your browser and navigate to:
   ```
   http://localhost/Cleaning%20Service/setup_database.php
   ```
2. Click the "Run Database Setup" button
3. The script will automatically:
   - Create the `cleaning_service` database
   - Create all required tables
   - Insert sample data

### **Step 2: Verify Setup**
- Once setup completes, you'll see a success message
- Navigate to `http://localhost/Cleaning%20Service/index.php`

---

## 📊 Database Tables Created

### **1. users**
- User authentication and profile information
- Columns: id, name, email, phone, password, address, city, postal_code, user_type, status

### **2. services**
- Cleaning services offered
- Columns: id, name, description, price, duration, category, image, status

### **3. bookings**
- Customer service bookings
- Columns: id, user_id, service_id, booking_date, booking_time, duration, address, notes, status, total_amount

### **4. team_members**
- Staff information
- Columns: id, name, position, phone, email, image, bio, specialization, experience, status

### **5. blog_posts**
- Blog articles
- Columns: id, title, slug, content, author_id, category, featured_image, status, views

### **6. gallery**
- Portfolio/gallery images
- Columns: id, title, description, image_url, service_id, category, status

### **7. contact_messages**
- Contact form submissions
- Columns: id, name, email, phone, subject, message, status

### **8. settings**
- Website configuration settings
- Columns: id, setting_key, setting_value

---

## 🔗 Navigation Updates

All navigation links have been updated from `.html` to `.php`:
- Home: `index.php`
- About: `about.php`
- Services: `service.php`
- Blog: `blog.php`
- Gallery: `portfolio.php`
- Team: `team.php`
- Contact: `contact.php`
- Login: `login.php`
- Register: `register.php`

---

## 📁 File Structure

```
Cleaning Service/
├── config.php                 # Database configuration
├── setup_database.php         # Database initialization
├── header.php                 # Reusable header component
├── footer.php                 # Reusable footer component
├── index.php                  # Home page
├── about.php                  # About us page
├── service.php                # Services page
├── service-details.php        # Service details
├── blog.php                   # Blog listing
├── blog-details.php          # Blog post
├── portfolio.php             # Gallery
├── portfolio-details.php     # Portfolio item
├── team.php                  # Team page
├── team-details.php          # Team member details
├── contact.php               # Contact page
├── login.php                 # Login page
├── register.php              # Registration page
├── 404.php                   # Error page
└── assets/                   # CSS, JS, images
```

---

## 🚀 Usage Instructions

### **First Time Setup**
1. Ensure XAMPP is running (Apache & MySQL)
2. Visit: `http://localhost/Cleaning%20Service/setup_database.php`
3. Click "Run Database Setup"
4. Wait for confirmation message
5. Navigate to `http://localhost/Cleaning%20Service/index.php`

### **Regular Access**
- Simply visit the website URL
- All pages will automatically include header and footer
- Database connection is established on each page load

---

## 🔐 Database Credentials

**Default Configuration (in config.php):**
- Host: `localhost`
- User: `root`
- Password: (empty)
- Database: `cleaning_service`

To change credentials, edit `config.php` and modify these lines:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'cleaning_service');
```

---

## 📝 Sample Data Included

The setup script automatically inserts:
- **5 Services** (Room Cleaning, Kitchen Cleaning, Office Cleaning, Window Cleaning, Green Cleaning)
- **3 Team Members** (John Smith, Sarah Johnson, Mike Davis)

---

## 🐛 Troubleshooting

### **Error: Unknown database 'cleaning_service'**
- Solution: Visit `setup_database.php` and run the database setup

### **Can't connect to MySQL**
- Verify XAMPP MySQL service is running
- Check database credentials in `config.php`

### **Header/Footer not displaying**
- Ensure `header.php` and `footer.php` are in the root directory
- Check file paths are correct

### **Blank pages**
- Check browser console for errors
- Verify all asset paths are correct (CSS, JS, images)

---

## 💡 Next Steps (Optional Enhancements)

1. **User Authentication System**
   - Implement login/registration logic in login.php and register.php
   - Add session management

2. **Booking System**
   - Create booking form functionality
   - Send confirmation emails

3. **Admin Dashboard**
   - Create admin panel for managing services, bookings, and users

4. **Payment Integration**
   - Add payment gateway for online bookings

5. **Email Notifications**
   - Send confirmation emails to users
   - Admin notifications for new bookings

---

## 📞 Support

For issues or questions:
1. Check the troubleshooting section above
2. Verify all files are in the correct location
3. Ensure database setup was completed successfully

---

**Last Updated:** February 3, 2026
**Version:** 1.0
**Status:** ✅ Complete - Ready for Use
